/*------------------------------------------------------------------------------*
 * File Name:ResizeControl.h													*
 * Creation: TD 9/5/2003														*
 * Purpose: OriginC Header file for Panel control base class					*
 * Copyright (c) Originlab Corp. 2003, 2004, 2005, 2006, 						*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 1/20/04 CHANGE_GRID_CONTROL_TO_WORK_WITH_PROPERTY_PAGE					*
 *  DG 4/27/05 QA70-7581 v8.0227 TREE_CTRL_IN_PROPERTYPAGE_NEED_MSG				*
 *	Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST	*
 *	Folger 07/05/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT						*
 *------------------------------------------------------------------------------*/
#ifndef _RESIZE_CONTROL_H_
#define _RESIZE_CONTROL_H_

#define STR_INCREASE_HEIGHT	_L("Enlarge Panel")
#define STR_DECREASE_HEIGHT	_L("Shrink Panel")

// base class for a control that can serve as the main control in a control group
// that we call a Panel
class ResizeControl
{
public:
	ResizeControl()
	{
	}
	~ResizeControl()
	{
	}
	//---- CPY 1/20/04 CHANGE_GRID_CONTROL_TO_WORK_WITH_PROPERTY_PAGE
	//void InitControl(int nID, Dialog& dlg)
	//void InitControl(int nID, WndContainer& dlg)	///DG TREE_CTRL_IN_PROPERTYPAGE_NEED_MSG
	void InitControl(int nID, WndContainer& dlg, WndContainer* pParentDlg = NULL)
	//----
	{
		m_cntrl 	= dlg.GetDlgItem(nID);
		
		///DG TREE_CTRL_IN_PROPERTYPAGE_NEED_MSG
		if(NULL != pParentDlg)
		{
			Window wTemp(pParentDlg->GetSafeHwnd());
			m_wndDlg = wTemp;
			return;
		}
		///end TREE_CTRL_IN_PROPERTYPAGE_NEED_MSG
		
		//---- CPY 1/20/04 CHANGE_GRID_CONTROL_TO_WORK_WITH_PROPERTY_PAGE
		// following code does not work, so Tarak suggested a dirty temp solution
		//m_wndDlg.Attach(dlg);
		Window wTemp(dlg.GetSafeHwnd());
		m_wndDlg = wTemp;
		//---- end 
	}
	void GetRect(RECT& rect)
	{
		m_cntrl.GetWindowRect(&rect);
		m_wndDlg.ScreenToClient(&rect);
	}
	void ClientToScreen(RECT& rect)
	{
		m_wndDlg.ClientToScreen(&rect);
	}
	void ScreenToClient(RECT& rect)
	{
		m_wndDlg.ScreenToClient(&rect);
	}
	void GetWindowRect(RECT& rect)
	{
		m_cntrl.GetWindowRect(&rect);
	}
	string FontName() {return m_wndDlg.FontName;}
	int	FontSize() {return m_wndDlg.FontSize;}
	void PostDlgMessage(uint msg, DWORD wParam = 0, DWORD lParam = 0)
	{
		m_wndDlg.PostMessage(msg, wParam, lParam);
	}
	///----Frank 11/16/05 QA70-8293 RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC
	void SentDlgMessage(uint msg, DWORD wParam = 0, DWORD lParam = 0)
	{
		m_wndDlg.SendMessage( msg, wParam, lParam);
	}
	///----End RETURN_FALSE_IF_NOT_HANDLE_IN_ROW_AND_RC
	HWND	GetDlgSafeHwnd()
	{
		return m_wndDlg.GetSafeHwnd();
	}

	///------ Folger 07/02/10 ORG-436-S1 TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST
	HWND	GetCtrnlSafeHwnd()
	{
		return *GetControl() ? GetControl()->GetSafeHwnd() : NULL;
	}
	///------ End TOOLTIP_NEEDED_FOR_DATA_INFO_RWO_SELECTION_LIST

	virtual bool SetVisible(bool bSet = true)
	{
		bool bOldVal = IsVisible();
		if(m_cntrl)
			m_cntrl.Visible = bSet;
		return bOldVal;
	}
	virtual bool IsVisible()
	{
		if(m_cntrl)
		{
			if(m_cntrl.Visible)
				return true;
		}
		return false;
	}
	void SetToolTipsText(const string& str, bool bCheckSame = true)
	{
		if(bCheckSame && m_strLastTooltips.CompareNoCase(str) == 0)
			return;
		
		m_cntrl.SetToolTip(str);
		m_strLastTooltips = str;
	}
	void MoveWindow(RECT& rect)
	{
		m_cntrl.MoveWindow(&rect);
	}
	int PixelsToTwips(int pixels, bool bX=true)
	{
		///------ Folger 07/05/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT
		//DeviceContext dc = m_cntrl.GetDC();
		DeviceContext dc(m_cntrl);
		///------ End BETTER_USE_OC_DEVICE_CONTEXT
		double vv = 0.5 + pixels * 1440.0 / dc.GetDeviceCaps(bX? LOGPIXELSX : LOGPIXELSY);
		return vv;
	}
	int TwipsToPixels(int twips, bool bX=true)
	{
		///------ Folger 07/05/10 ORG-436 BETTER_USE_OC_DEVICE_CONTEXT
		//DeviceContext dc = m_cntrl.GetDC();
		DeviceContext dc(m_cntrl);
		///------ End BETTER_USE_OC_DEVICE_CONTEXT
		
		double vv = 0.5 + dc.GetDeviceCaps(bX? LOGPIXELSX : LOGPIXELSY) * (double)twips / 1440.0;
		return vv;
	}
public:
	virtual bool IsResize(bool bOnExpand = true) { return IsVisible();}
	virtual int	GetPanelHeight(bool bGetMin = false) {return 0;}
	virtual int GetPanelWidth(bool bGetMin = false) {return 0;}

	virtual int GetMinHeight(bool bKeepFunctional = false) {return 24;}
	virtual int GetMaxHeight(bool bKeepFunctional = false) {return GetSystemMetrics(SM_CYSCREEN)/2;}
	virtual string GetRuntimeClass()
	{
		return "ResizeControl";
	}
	// when using this control as the Main control of a Panel (group)
	virtual int GetHeight(bool bDefault = false)
	{		
		RECT r1;
		GetRect(r1);//GetWindowRect(r1);	///Jasmine 04/16/07 BE_SAME_WITH_SET+HEIGHT
		return RECT_HEIGHT(r1);
	}
	// must return actual height, control might have minimum height
	virtual int SetHeight(int nHeight)
	{
		RECT r1;
		if(nHeight < GetMinHeight())
			return GetHeight();
		if(nHeight > GetMaxHeight())
			nHeight = GetMaxHeight();
		GetRect(r1);
		r1.bottom = r1.top + nHeight;
		MoveWindow(r1);
		return GetHeight();
	}
protected:
	Control*	GetControl() 
	{
		if(m_cntrl)
			return &m_cntrl;
		return NULL;
	}
	
	Window*		GetDialogWindow()
	{
		if( m_wndDlg )
			return &m_wndDlg;
		
		return NULL;
	}
private:
	Control 	m_cntrl;
	Window		m_wndDlg;
	string		m_strLastTooltips;
};

#endif //_RESIZE_CONTROL_H_

